/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.orderform.ServerOrderCallbacks;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.orderform.screen.OrderServerScreen;
import net.creeperhost.polylib.client.screen.ScreenHelper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderDetailsScreen
extends OrderServerScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean placingOrder = false;
    private boolean placedOrder = false;
    private boolean creatingAccount = false;
    private boolean createdAccount = false;
    private String createdAccountError = "";
    private int orderNumber;
    private String invoiceID;
    private String placedOrderError = "";
    private Button buttonInvoice;
    private boolean serverAdded;
    private int ticks = 0;

    public OrderDetailsScreen(int stepId, Order order) {
        super(stepId, order);
        if (order.clientID != null && !order.clientID.isEmpty()) {
            this.creatingAccount = false;
            this.createdAccount = true;
        }
    }

    @Override
    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.buttonNext.m_93666_((Component)new TranslatableComponent("minetogether.button.finish"));
        this.buttonNext.f_93624_ = false;
        this.buttonCancel.m_93666_((Component)new TranslatableComponent("minetogether.order.ordercancel"));
        this.buttonCancel.f_93623_ = false;
        this.buttonPrev.f_93623_ = false;
        this.buttonPrev.f_93624_ = false;
        this.buttonInvoice = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40, this.f_96544_ / 2 + 30, 80, 20, (Component)new TranslatableComponent("minetogether.button.invoice"), p -> {
            try {
                Util.m_137581_().m_137648_(new URI(ServerOrderCallbacks.getPaymentLink(this.invoiceID)));
            }
            catch (Throwable throwable) {
                LOGGER.error("Couldn't open link", throwable);
            }
        }));
        this.buttonNext.f_93624_ = true;
        this.buttonNext.f_93623_ = true;
        this.buttonInvoice.f_93624_ = false;
    }

    public void m_96624_() {
        ++this.ticks;
        super.m_96624_();
        if (!this.createdAccount && !this.creatingAccount) {
            if (!this.createdAccountError.isEmpty()) {
                this.buttonCancel.f_93623_ = true;
                return;
            }
            this.creatingAccount = true;
            CompletableFuture.runAsync(() -> {
                String result = ServerOrderCallbacks.createAccount(this.order);
                String[] resultSplit = result.split(":");
                if (resultSplit[0].equals("success")) {
                    this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                    this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "0";
                } else {
                    this.createdAccountError = result;
                    this.createdAccount = true;
                }
                this.creatingAccount = false;
                this.createdAccount = true;
            });
        } else {
            if (this.creatingAccount) {
                return;
            }
            if (!this.createdAccountError.isEmpty()) {
                this.buttonCancel.f_93623_ = true;
                return;
            }
            if (!this.placingOrder && !this.placedOrder) {
                this.placingOrder = true;
                this.buttonNext.f_93623_ = false;
                Runnable runnable = () -> {
                    String result = ServerOrderCallbacks.createOrder(this.order, String.valueOf(Config.instance().pregenDiameter));
                    String[] resultSplit = result.split(":");
                    if (resultSplit[0].equals("success")) {
                        this.invoiceID = resultSplit[1] != null ? resultSplit[1] : "0";
                        this.orderNumber = Integer.parseInt(resultSplit[2]);
                    } else {
                        this.placedOrderError = result;
                    }
                    this.placedOrder = true;
                    this.placingOrder = false;
                };
                Thread thread = new Thread(runnable);
                thread.start();
                this.buttonCancel.f_93623_ = false;
            } else {
                if (this.placingOrder) {
                    return;
                }
                if (this.placedOrderError.isEmpty()) {
                    if (!this.serverAdded) {
                        this.serverAdded = this.addServerEntry();
                    }
                    this.buttonInvoice.f_93624_ = true;
                    this.buttonNext.f_93624_ = true;
                    this.buttonCancel.f_93623_ = false;
                    this.buttonNext.f_93623_ = true;
                } else {
                    this.buttonNext.f_93623_ = true;
                }
            }
        }
        this.buttonCancel.f_93623_ = this.placedOrder;
    }

    public boolean addServerEntry() {
        ServerList savedServerList = new ServerList(this.f_96541_);
        savedServerList.m_105431_();
        savedServerList.m_105443_(this.getServerEntry(this.order));
        savedServerList.m_105442_();
        return true;
    }

    public ServerData getServerEntry(Order order) {
        return new ServerData(order.name + ".PlayAt.CH", order.name + ".playat.ch", false);
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        OrderDetailsScreen.m_93172_((PoseStack)matrixStack, (int)0, (int)(this.f_96544_ - 20), (int)this.f_96543_, (int)20, (int)-1728053248);
        if (this.creatingAccount) {
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.accountcreating", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
        } else if (!this.createdAccountError.isEmpty()) {
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.accounterror", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
            List list = ComponentRenderUtils.m_94005_((FormattedText)new TranslatableComponent(this.createdAccountError), (int)(this.f_96543_ - 30), (Font)this.f_96547_);
            int offset = 10;
            for (FormattedCharSequence str : list) {
                this.drawCenteredString(matrixStack, str, this.f_96543_ / 2, this.f_96544_ / 2 + offset, 0xFFFFFF);
                offset += 10;
            }
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.accounterrorgoback", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + offset), (int)0xFFFFFF);
        } else if (this.placingOrder) {
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.orderplacing", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
            ScreenHelper.loadingSpin((PoseStack)matrixStack, (float)partialTicks, (int)this.ticks, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 20), (ItemStack)new ItemStack((ItemLike)Items.f_42579_));
        } else if (!this.placedOrderError.isEmpty()) {
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.ordererror", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
            List list = ComponentRenderUtils.m_94005_((FormattedText)new TranslatableComponent(this.placedOrderError), (int)(this.f_96543_ - 30), (Font)this.f_96547_);
            int offset = 10;
            for (FormattedCharSequence str : list) {
                this.drawCenteredString(matrixStack, str, this.f_96543_ / 2, this.f_96544_ / 2 + offset, 0xFFFFFF);
                offset += 10;
            }
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.ordererrorsupport", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + offset), (int)0xFFFFFF);
        } else {
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.ordersuccess", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
            OrderDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.order.ordermodpack", (Object[])new Object[0]), (int)(this.f_96543_ / 2 + 10), (int)(this.f_96544_ / 2 + 10), (int)0xFFFFFF);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void drawCenteredString(PoseStack matrixStack, FormattedCharSequence text, int x, int y, int color) {
        Minecraft.m_91087_().f_91062_.m_92744_(matrixStack, text, (float)(x - Minecraft.m_91087_().f_91062_.m_92724_(text) / 2), (float)y, color);
    }

    @Override
    public void cancelOrder() {
        ServerOrderCallbacks.cancelOrder(this.orderNumber);
        super.cancelOrder();
    }

    @Override
    public String getStepName() {
        return I18n.m_118938_((String)"minetogether.screen.order", (Object[])new Object[0]);
    }
}

